/*
 * Decompiled with CFR 0.152.
 */
package com.refinedmods.refinedstorage.render.model;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.math.Vector3f;
import com.refinedmods.refinedstorage.RSBlocks;
import com.refinedmods.refinedstorage.apiimpl.network.node.DiskState;
import com.refinedmods.refinedstorage.block.DiskManipulatorBlock;
import com.refinedmods.refinedstorage.block.NetworkNodeBlock;
import com.refinedmods.refinedstorage.blockentity.DiskManipulatorBlockEntity;
import com.refinedmods.refinedstorage.render.model.DelegateBakedModel;
import com.refinedmods.refinedstorage.render.model.QuadTransformer;
import com.refinedmods.refinedstorage.util.ColorMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.data.IModelData;

public class DiskManipulatorBakedModel
extends DelegateBakedModel {
    private final BakedModel baseConnected;
    private final BakedModel baseDisconnected;
    private final BakedModel disk;
    private final BakedModel diskNearCapacity;
    private final BakedModel diskFull;
    private final BakedModel diskDisconnected;
    private final LoadingCache<CacheKey, List<BakedQuad>> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<CacheKey, List<BakedQuad>>(){

        public List<BakedQuad> load(CacheKey key) {
            Direction facing = (Direction)key.state.m_61143_((Property)((DiskManipulatorBlock)((Object)RSBlocks.DISK_MANIPULATOR.get(ColorMap.DEFAULT_COLOR).get())).getDirection().getProperty());
            boolean connected = (Boolean)key.state.m_61143_((Property)NetworkNodeBlock.CONNECTED);
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>(QuadTransformer.getTransformedQuads(connected ? DiskManipulatorBakedModel.this.baseConnected : DiskManipulatorBakedModel.this.baseDisconnected, facing, null, key.state, key.random, key.side));
            int x = 0;
            int y = 0;
            for (int i = 0; i < 6; ++i) {
                if (key.diskState[i] != DiskState.NONE) {
                    BakedModel diskModel = this.getDiskModel(key.diskState[i]);
                    quads.addAll(QuadTransformer.getTransformedQuads(diskModel, facing, this.getDiskTranslation(facing, x, y), key.state, key.random, key.side));
                }
                ++y;
                if ((i + 1) % 3 != 0) continue;
                ++x;
                y = 0;
            }
            return quads;
        }

        private BakedModel getDiskModel(DiskState diskState) {
            switch (diskState) {
                case DISCONNECTED: {
                    return DiskManipulatorBakedModel.this.diskDisconnected;
                }
                case NEAR_CAPACITY: {
                    return DiskManipulatorBakedModel.this.diskNearCapacity;
                }
                case FULL: {
                    return DiskManipulatorBakedModel.this.diskFull;
                }
            }
            return DiskManipulatorBakedModel.this.disk;
        }

        private Vector3f getDiskTranslation(Direction facing, int x, int y) {
            Vector3f translation = new Vector3f();
            if (facing == Direction.NORTH || facing == Direction.SOUTH) {
                translation.m_122272_((0.125f + (float)x * 7.0f / 16.0f) * (float)(facing == Direction.NORTH ? -1 : 1), 0.0f, 0.0f);
            } else if (facing == Direction.EAST || facing == Direction.WEST) {
                translation.m_122272_(0.0f, 0.0f, (0.125f + (float)x * 7.0f / 16.0f) * (float)(facing == Direction.EAST ? -1 : 1));
            }
            translation.m_122272_(0.0f, -(0.375f + 3.0f * (float)y / 16.0f), 0.0f);
            return translation;
        }
    });

    public DiskManipulatorBakedModel(BakedModel baseConnected, BakedModel baseDisconnected, BakedModel disk, BakedModel diskNearCapacity, BakedModel diskFull, BakedModel diskDisconnected) {
        super(baseConnected);
        this.baseConnected = baseConnected;
        this.baseDisconnected = baseDisconnected;
        this.disk = disk;
        this.diskNearCapacity = diskNearCapacity;
        this.diskFull = diskFull;
        this.diskDisconnected = diskDisconnected;
    }

    @Nonnull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData data) {
        DiskState[] diskState = (DiskState[])data.getData(DiskManipulatorBlockEntity.DISK_STATE_PROPERTY);
        if (diskState == null) {
            return this.base.getQuads(state, side, rand, data);
        }
        CacheKey key = new CacheKey(state, side, diskState, rand);
        return (List)this.cache.getUnchecked((Object)key);
    }

    private static class CacheKey {
        private final BlockState state;
        private final Direction side;
        private final DiskState[] diskState;
        private final Random random;

        CacheKey(BlockState state, @Nullable Direction side, DiskState[] diskState, Random random) {
            this.state = state;
            this.side = side;
            this.diskState = diskState;
            this.random = random;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            if (!this.state.equals(cacheKey.state)) {
                return false;
            }
            if (this.side != cacheKey.side) {
                return false;
            }
            return Arrays.equals((Object[])this.diskState, (Object[])cacheKey.diskState);
        }

        public int hashCode() {
            int result = this.state.hashCode();
            result = 31 * result + (this.side != null ? this.side.hashCode() : 0);
            result = 31 * result + Arrays.hashCode((Object[])this.diskState);
            return result;
        }
    }
}

